namespace WinampPlugin
{
    using AirClick;
    using System;
    using System.Diagnostics;
    using System.Timers;
    using System.Runtime.InteropServices;
    
    using Org.Mentalis.Utilities;


    public class Win32
    {

        public const int HWND_BROADCAST = 0xffff;
        public const uint WM_APPCOMMAND = 0x0319;

        public const uint APPCOMMAND_BROWSER_BACKWARD  =     1;
        public const uint APPCOMMAND_BROWSER_FORWARD   =     2;
        public const uint APPCOMMAND_BROWSER_REFRESH   =     3;
        public const uint APPCOMMAND_BROWSER_STOP      =     4;
        public const uint APPCOMMAND_BROWSER_SEARCH    =     5;
        public const uint APPCOMMAND_BROWSER_FAVORITES =     6;
        public const uint APPCOMMAND_BROWSER_HOME      =     7;
        public const uint APPCOMMAND_VOLUME_MUTE       =     8;
        public const uint APPCOMMAND_VOLUME_DOWN       =     9;
        public const uint APPCOMMAND_VOLUME_UP         =     10;
        public const uint APPCOMMAND_MEDIA_NEXTTRACK   =     11;
        public const uint APPCOMMAND_MEDIA_PREVIOUSTRACK =   12;
        public const uint APPCOMMAND_MEDIA_STOP          =   13;
        public const uint APPCOMMAND_MEDIA_PLAY_PAUSE    =   14;
        public const uint APPCOMMAND_LAUNCH_MAIL         =   15;
        public const uint APPCOMMAND_LAUNCH_MEDIA_SELECT =   16;
        public const uint APPCOMMAND_LAUNCH_APP1         =   17;
        public const uint APPCOMMAND_LAUNCH_APP2         =   18;
        public const uint APPCOMMAND_BASS_DOWN           =   19;
        public const uint APPCOMMAND_BASS_BOOST          =   20;
        public const uint APPCOMMAND_BASS_UP             =   21;
        public const uint APPCOMMAND_TREBLE_DOWN         =   22;
        public const uint APPCOMMAND_TREBLE_UP = 23;
        

        [DllImport("user32.dll")]
        public static extern int FindWindow(
            string lpClassName,  // class name
            string lpWindowName  // window name
            );

        [DllImport("user32.dll")]
        public static extern int FindWindowEx(int hwndParent,
            int hwndChildAfter, string strClassName, string strWindowName);

        [DllImport("user32.dll")]
        public static extern int SendMessage(
            uint hWnd,     // handle to destination window
            uint Msg,      // message
            uint wParam,   // first message parameter
            uint lParam    // second message parameter
            );

        [DllImport("user32.dll")]
        public static extern int GetForegroundWindow();


        //public const uint INPUT_KEYBOARD = 1;
        //public const int KEY_EXTENDED = 1;
        public const uint KEYEVENTF_KEYUP = 2;
        //public const uint KEY_SCANCODE = 4;

        public class INPUT
        {
            public const int MOUSE = 0;
            public const int KEYBOARD = 1;
            public const int HARDWARE = 2;
        }

        public class MOUSEEVENTF
        {
            public const int MOVE = 0x0001; /* mouse move */
            public const int LEFTDOWN = 0x0002; /* left button down */
            public const int LEFTUP = 0x0004; /* left button up */
            public const int RIGHTDOWN = 0x0008; /* right button down */
            public const int RIGHTUP = 0x0010; /* right button up */
            public const int MIDDLEDOWN = 0x0020; /* middle button down */
            public const int MIDDLEUP = 0x0040; /* middle button up */
            public const int XDOWN = 0x0080; /* x button down */
            public const int XUP = 0x0100; /* x button down */
            public const int WHEEL = 0x0800; /* wheel button rolled */
            public const int VIRTUALDESK = 0x4000; /* map to entire 
                                            virtual <A class=iAs style="FONT-WEIGHT: normal; FONT-SIZE: 100%; PADDING-BOTTOM: 1px; COLOR: darkgreen; BORDER-BOTTOM: darkgreen 0.07em solid; BACKGROUND-COLOR: transparent; TEXT-DECORATION: underline" href="#" target=_blank itxtdid="4603670">desktop</A> */
            public const int ABSOLUTE = 0x8000; /* absolute move */
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct MOUSEINPUT
        {
            public int dx;
            public int dy;
            public int mouseData;
            public int dwFlags;
            public int time;
            public IntPtr dwExtraInfo;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct KEYBDINPUT
        {
            public ushort wVk;
            public ushort wScan;
            public uint dwFlags;
            public uint time;
            public IntPtr dwExtraInfo;
        }

        [StructLayout(LayoutKind.Explicit)]
        public struct Input
        {
            [FieldOffset(0)]
            public int type;
            [FieldOffset(4)]
            public MOUSEINPUT mi;
            [FieldOffset(4)]
            public KEYBDINPUT ki;
            //[FieldOffset(4)]
            //public HARDWAREINPUT hi;
        }

        [DllImport("User32.dll")]
        public static extern UInt32 SendInput
        (
            UInt32 nInputs,
            Input[] pInputs,
            Int32 cbSize
        );

        public Win32()
        {
        }

        ~Win32()
        {
        }

    }


    public class WinampPlugin : Plugin
    {
        public WinampPlugin()
        {

            //ID - a unique integer ID given to the button. This ID is passed back also a paramter in the "Notify" 
            // method to tell a plugin which one of his buttons has been pressed.

            //Key - the button on the AirClick remote you want to know about.
            //Values can be back, forward, play, voldown, or volup.

            //Modifier - a modifer key that must be held down along with the "Key". 
            //Values can be back, forward, play, voldown, volup, or none.

            //Time - the number of milliseconds the "Key" must be held down in order to trigger this button press.

            //OnRelease - true if button is triggerd when it is released, false if it is triggered on push.

            //Name - short description of this button, such as "Play" or "Next Chapter". 
            //(Presently not used, just there for potential future updates.)

            //ShowInMenu - whether or not this button's name should appear in a list of this plugin's functionality. 
            //(Presently not used, just there for potential future updates.)

            //Notify- This method is called by the AirClick software when a desired button press is found, 
            //and the ID of the found button pressed is passed to it.

            //                 Button(ID, Key, Modifier, Time, OnRelease, Name, ShowInMenu)

            base.AddButton(new Button(1,  1,    0, 0,   true,  "Play/Pause",       true));

            base.AddButton(new Button(2, 0x10, 0, 500, false, "Rewind", true));
            base.AddButton(new Button(3, 8, 0, 500, false, "Fast Forward", true));

            base.AddButton(new Button(4,  0x10, 0, 0,   false,  "Previous",         true));
            base.AddButton(new Button(5,  8,    0, 0,   false,  "Next",             true));

            base.AddButton(new Button(6,  2,    0, 0,   false,  "Volume Up",        true));
            base.AddButton(new Button(7,  4,    0, 0,   false,  "Volume Down",      true));
            base.AddButton(new Button(8,  2,    0, 100, false, "Volume Up cont",   false));
            base.AddButton(new Button(9,  4,    0, 100, false, "Volume Down cont", false));
            base.AddButton(new Button(10, 2,    0, 0,   true,  "Volume Up end",    false));
            base.AddButton(new Button(11, 4,    0, 0,   true,  "Volume Down end",  false));

            base.AddButton(new Button(12, 0x10, 0, 0, true, "Rewind end", true));
            base.AddButton(new Button(13, 8, 0, 0, true, "Fast Forward end", true));

            base.AddButton(new Button(14, 1, 0, 1500, false, "Keyboard mode", true));

            base.AddButton(new Button(15, 1, 0, 5000, false, "Shutdown mode", true));

            this.VolumeTimer = new Timer(VolTimerInterval);
            this.VolumeTimer.Enabled = false;
            this.VolumeTimer.AutoReset = true;
            this.VolumeTimer.SynchronizingObject = OSD.Synchronizer;
            this.VolumeTimer.Elapsed += new ElapsedEventHandler(this.VolumeChanged);
            
            this.RewTimer = new Timer(500);
            this.RewTimer.Enabled = false;
            this.RewTimer.AutoReset = true;
            this.RewTimer.SynchronizingObject = OSD.Synchronizer;
            this.RewTimer.Elapsed += new ElapsedEventHandler(this.Rewind);

            this.FFTimer = new Timer(500);
            this.FFTimer.Enabled = false;
            this.FFTimer.AutoReset = true;
            this.FFTimer.SynchronizingObject = OSD.Synchronizer;
            this.FFTimer.Elapsed += new ElapsedEventHandler(this.FastForward);
            this.inKeyboardMode = false;
            this.justSwitchedMode = false;
            this.no_osd = true;
        }

        public int getOperationWindow()
        {
            int hwnd = Win32.HWND_BROADCAST;
            hwnd = Win32.FindWindow("eHome Render Window", "Windows Media Center");
            if (hwnd == 0)
                hwnd = Win32.GetForegroundWindow();
            return hwnd;
        }

        public void sendKey(ushort vk, bool press)
        {
            Win32.Input[] inp = new Win32.Input[1];

            inp[0].type = Win32.INPUT.KEYBOARD;
            inp[0].ki.wVk = vk;
            inp[0].ki.wScan = 0;
            if (press)
                inp[0].ki.dwFlags = 0;
            else
                inp[0].ki.dwFlags = Win32.KEYEVENTF_KEYUP;

            Win32.SendInput(1, inp, Marshal.SizeOf(inp[0]));

       }

        public void emulateKey(ushort vk)
        {
            sendKey(vk, true);
            sendKey(vk, false);
        } 

        public bool isWMCE() {
            return (Win32.FindWindow("eHome Render Window", "Windows Media Center") == Win32.GetForegroundWindow());
        }

        public bool isFlash()
        {
            return (Win32.FindWindow("ShockwaveFlashFullScreen", null) == Win32.GetForegroundWindow());
        }

        public override void Notify(int buttonID)
        {
            switch (buttonID)
            {
                case 1:
                    this.PlayPause();
                    return;

                case 2:
                    this.Rewind();
                    return;

                case 3:
                    this.FastForward();
                    return;

                case 4:
                    this.Previous();
                    return;

                case 5:
                    this.Next();
                    return;

                case 6:
                    this.VolumeUp();
                    return;

                case 7:
                    this.VolumeDown();
                    return;

                case 8:
                    this.VolumeUpCont();
                    return;

                case 9:
                    this.VolumeDownCont();
                    return;

                case 10:
                    this.VolumeUpEnd();
                    return;

                case 11:
                    this.VolumeDownEnd();
                    return;

                case 12:
                    this.RewindEnd();
                    return;

                case 13:
                    this.FastForwardEnd();
                    return;

                case 14:
                    this.KeyBoardMode();
                    return;

                case 15:
                    this.ShutdownMode();
                    return;
            }
        }

        private void KeyBoardMode()
        {
            this.justSwitchedMode = true;
            this.inKeyboardMode = !this.inKeyboardMode;
            if (this.inKeyboardMode)
            {
                OSD.Display("Keyboard", OSD.DisplayGraphic.none);
                if (Win32.FindWindow("eHome Render Window", "Windows Media Center") == Win32.GetForegroundWindow())
                  emulateKey(93);
            }
            else
                OSD.Display("Multimedia", OSD.DisplayGraphic.none);
        }

        private void ShutdownMode()
        {
            OSD.Display("Shutdown", OSD.DisplayGraphic.none);
            Org.Mentalis.Utilities.WindowsController.ExitWindows(RestartOptions.PowerOff, false);
        }

        private void PlayPause()
        {
            /*
            uint hwnd = getOperationWindow();// Win32.GetForegroundWindow(); //Win32.HWND_BROADCAST;
            uint wP = hwnd;
            uint lP = Win32.APPCOMMAND_MEDIA_PLAY_PAUSE * 0x10000;
            Win32.SendMessage(hwnd, Win32.WM_APPCOMMAND, wP, lP);*/
            if (this.justSwitchedMode)
            {
                this.justSwitchedMode = false;
                return;
            }

            if (!this.inKeyboardMode)
            {
                if ( isFlash() )
                  emulateKey(32); // Flash uses space bar
                else
                  emulateKey(179); // the rest is multimedia play/pause

                if (!isWMCE())
                    if (!no_osd) OSD.Display("Multimedia", OSD.DisplayGraphic.playpause);
            }
            else
            {
                emulateKey(13);
                //OSD.Display("Enter", OSD.DisplayGraphic.none);
            }
        }

        private void FastForward()
        {
            this.FFTimer.Enabled = true;
        }

        private void FastForwardEnd()
        {
            this.FFTimer.Enabled = false;
        }

        private void FastForward(object sender, ElapsedEventArgs e)
        {
            /*uint hwnd = getOperationWindow();// Win32.GetForegroundWindow(); //Win32.HWND_BROADCAST;
            uint wP = hwnd;
            uint lP = Win32.APPCOMMAND_MEDIA_NEXTTRACK * 0x10000;
            Win32.SendMessage(hwnd, Win32.WM_APPCOMMAND, wP, lP);*/
            emulateKey(176);
            if (!isWMCE())
                if (!no_osd) OSD.Display("Multimedia", OSD.DisplayGraphic.ff);
        }

        private void Next()
        {
            /*uint hwnd = getOperationWindow();// Win32.GetForegroundWindow(); //Win32.HWND_BROADCAST;
            uint wP = hwnd;
            uint lP = Win32.APPCOMMAND_MEDIA_NEXTTRACK * 0x10000;
            Win32.SendMessage(hwnd, Win32.WM_APPCOMMAND, wP, lP);*/

            if (!this.inKeyboardMode)
            {
                // if it's media center, try to change channel, otherwise we do next
                if ( isWMCE() )
                    emulateKey(33);
                
                // in flash use right arrow
                if (isFlash())
                    emulateKey(39);
                else
                    emulateKey(176);

                //if (Win32.FindWindow("eHome Render Window", "Windows Media Center") == Win32.GetForegroundWindow())
                if ( !isWMCE() )
                  if (!no_osd) OSD.Display("Multimedia", OSD.DisplayGraphic.next);
            }
            else
            {
                emulateKey(38);
                //OSD.Display("Keyboard Up", OSD.DisplayGraphic.none);
            }
        }

        private void Previous()
        {
            /*uint hwnd = getOperationWindow();// Win32.GetForegroundWindow(); //Win32.HWND_BROADCAST;
            uint wP = hwnd;
            uint lP = Win32.APPCOMMAND_MEDIA_PREVIOUSTRACK * 0x10000;
            Win32.SendMessage(hwnd, Win32.WM_APPCOMMAND, wP, lP);*/

            if (!this.inKeyboardMode)
            {
                // if it's media center, try to change channel, otherwise we do next
                if (isWMCE())
                    emulateKey(34);

                // in flash use left arrow
                if (isFlash())
                    emulateKey(37);
                else
                    emulateKey(177);

                if (!isWMCE())
                  if (!no_osd) OSD.Display("Multimedia", OSD.DisplayGraphic.prev);
            }
            else
            {
                emulateKey(40);
                //OSD.Display("Keyboard Down", OSD.DisplayGraphic.none);
            }
        }

        private void Rewind()
        {
            this.RewTimer.Enabled = true;
        }

        private void RewindEnd()
        {
            this.RewTimer.Enabled = false;
        }

        private void Rewind(object sender, ElapsedEventArgs e)
        {
            /*uint hwnd = getOperationWindow();// Win32.GetForegroundWindow(); //Win32.HWND_BROADCAST;
            uint wP = hwnd;
            uint lP = Win32.APPCOMMAND_MEDIA_PREVIOUSTRACK * 0x10000;
            Win32.SendMessage(hwnd, Win32.WM_APPCOMMAND, wP, lP);*/
            emulateKey(177);
            if (!isWMCE())
                if (!no_osd) OSD.Display("Multimedia", OSD.DisplayGraphic.rewind);
        }

        private void VolumeDown()
        {
            /*uint hwnd = getOperationWindow();// Win32.GetForegroundWindow();
            uint wP = hwnd;
            uint lP = Win32.APPCOMMAND_VOLUME_DOWN * 0x10000;
            Win32.SendMessage(hwnd, Win32.WM_APPCOMMAND, wP, lP);*/

            if (!this.inKeyboardMode)
            {
                emulateKey(174);
                if (!isWMCE())
                    if (!no_osd) OSD.Display("Multimedia", OSD.DisplayGraphic.voldown);
            }
            else
            {
                emulateKey(37);
                //OSD.Display("Keyboard Left", OSD.DisplayGraphic.none);
            }
        }


        private void VolumeDownCont()
        {
            this.VolUp = false;
            this.VolumeTimer.Enabled = true;
        }

        private void VolumeDownEnd()
        {
            this.VolumeTimer.Enabled = false;
            this.VolumeTimer.Interval = VolTimerInterval;
        }

        private void VolumeUp()
        {
            /*uint hwnd = getOperationWindow();// Win32.GetForegroundWindow();
            uint wP = hwnd;
            uint lP = Win32.APPCOMMAND_VOLUME_UP * 0x10000;
            Win32.SendMessage(hwnd, Win32.WM_APPCOMMAND, wP, lP);*/

            if (!this.inKeyboardMode)
            {
                emulateKey(175);
                if (!isWMCE())
                    if (!no_osd) OSD.Display("Multimedia", OSD.DisplayGraphic.volup);
            }
            else
            {
                emulateKey(39);
                //OSD.Display("Keyboard Right", OSD.DisplayGraphic.none);
            }
        }

        private void VolumeUpCont()
        {
            this.VolUp = true;
            this.VolumeTimer.Enabled = true;
        }

        private void VolumeUpEnd()
        {
            this.VolumeTimer.Enabled = false;
            this.VolumeTimer.Interval = VolTimerInterval;
        }

        private void VolumeChanged(object sender, ElapsedEventArgs e)
        {
            if (this.VolUp)
            {
                this.VolumeUp();
            }
            else
            {
                this.VolumeDown();
            }
        }

        public override string Author
        {
            get
            {
                return "Dima Fedorov <www.dimin.net>";
            }
        }

        public override string Description
        {
            get
            {
                return "Multimedia Keyboard (no OSD) plugin for AirClick 2.0";
            }
        }

        public override string Executable
        {
            get
            {
                return "";
            }
        }

        public override string Name
        {
            get
            {
                return "Multimedia Keyboard (no OSD)";
            }
        }

        public override string Version
        {
            get
            {
                return "1.0.2";
            }
        }

        private Timer VolumeTimer;
        private Timer FFTimer;
        private Timer RewTimer;
        private bool VolUp;
        private const double VolTimerInterval = 100;
        private bool inKeyboardMode;
        private bool justSwitchedMode;
        private bool no_osd;
    }
}

