; Multimedia Keyboard plug-in for Griffin AirClick USB
; Dmitry V. Fedorov <www.dimin.net>
; ver: 1

;--------------------------------
;Include Modern UI

  !include "MUI.nsh"

;--------------------------------

; The name of the installer
Name "Multimedia Keyboard plug-in for Griffin AirClick USB"

; The file to write
OutFile "airclick_multimedia_plugin.exe"

; The default installation directory
InstallDir "$PROGRAMFILES\Griffin Technology\AirClick"

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\AirClick "InstallLocation"



ShowInstDetails show
CRCCheck on
XPStyle on

; The text to prompt the user to enter a directory
ComponentText "This will install Multimedia Keyboard plug-in for Griffin AirClick USB."
; The text to prompt the user to enter a directory
DirText "Choose directory where Griffin AirClick 2 is installed (Automatically detected):"

;--------------------------------
;Interface Settings

  ;!define MUI_COMPONENTSPAGE_NODESC
  ;!define MUI_COMPONENTSPAGE_SMALLDESC
  
  ;!define MUI_UI "install\modern.exe"
  
  ;!define MUI_HEADERIMAGE 
  ;!define MUI_HEADERIMAGE_BITMAP "install\div5_install_v2.bmp"
  ;!define MUI_HEADERIMAGE_BITMAP_NOSTRETCH
  
;--------------------------------
;Pages

 PageEx license
   LicenseText "Install Multimedia Keyboard plug-in 1.0.3 for AirClick" "Install >"
   LicenseData readme.txt
   Caption " "  
   ;SubCaption "dima subCaption"
 PageExEnd

  ;!insertmacro MUI_PAGE_COMPONENTS
  ;!insertmacro MUI_PAGE_DIRECTORY


Section ""
  Call IsAirClickExists
SectionEnd


  !insertmacro MUI_PAGE_INSTFILES

 PageEx license
   LicenseText "Usage instructions" "Finish"
   LicenseData AirClickMultimediaPlugIn.txt
   Caption " Instructions"  
 PageExEnd

  ;!insertmacro MUI_PAGE_FINISH
  
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"

;--------------------------------

; The stuff to install
Section "-Multimedia Keyboard plug-in (required)"
  SetOutPath "$INSTDIR\Plugins"
  File "Multimedia.acp"
  File "MultimediaNoOSD.acp"

  SetOutPath $INSTDIR  
  File "AirClickMultimediaPlugIn.txt"
  CreateShortCut "$SMPROGRAMS\Griffin Technology\AirClick\Multimedia Keyboard Plug-in Documentation.lnk" "$INSTDIR\AirClickMultimediaPlugIn.txt" "" "$INSTDIR\AirClickMultimediaPlugIn.txt" 0

  WriteUninstaller "uninstall_multimedia_plugin.exe"
SectionEnd


Function IsAirClickExists

    IfFileExists $INSTDIR\AirClick.exe PathGood
 
      MessageBox MB_YESNO "Griffin AirClick software was not found! Continue installing to $INSTDIR anyway?" IDYES NoAbort
        Abort ; causes installer to quit.
      NoAbort:
        Nop
    PathGood:
      Nop
  
FunctionEnd

;--------------------------------
; uninstall stuff

UninstallText "This will uninstall Multimedia Keyboard plug-in for Griffin AirClick USB."


; special uninstall section.
Section "Uninstall"
   
  ; remove files
  Delete $INSTDIR\Plugins\Multimedia.acp 
  Delete $INSTDIR\Plugins\MultimediaNoOSD.acp
         
  ; remove Start Menu shortcuts, if any.
  Delete "$INSTDIR\AirClickMultimediaPlugIn.txt"
  Delete "$SMPROGRAMS\Griffin Technology\AirClick\Multimedia Keyboard Plug-in Documentation.lnk"
  
  ; MUST REMOVE UNINSTALLER, too
  Delete "$INSTDIR\uninstall_multimedia_plugin.exe"
  
SectionEnd


; eof
